package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.dao.ReenvioComunicacionesDao;
import com.ejie.ab04b.model.ReenvioComunicaciones;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * ReenvioComunicacionesServiceImpl NO generated by UDA, 27-sep-2016 13:26:09.
 * 
 * @author NO UDA
 */

@Service(value = "reenvioComunicacionesService")
public class ReenvioComunicacionesServiceImpl implements
		ReenvioComunicacionesService {

	@Autowired
	private ReenvioComunicacionesDao reenvioComunicacionesDao;

	/**
	 * Filter method in the ComunicacionesAperturas table.
	 * 
	 *  filterReenvioComunicaciones
	 *            ReenvioComunicaciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<ReenvioComunicaciones>
	 *
	 * @param filterReenvioComunicaciones the filter reenvio comunicaciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */

	public JQGridResponseDto<ReenvioComunicaciones> findReenvioComunicaciones(
			ReenvioComunicaciones filterReenvioComunicaciones,
			JQGridRequestDto jqGridRequestDto) {

		List<ReenvioComunicaciones> listaComunicacionApertura = this.reenvioComunicacionesDao
				.findReenvioComunicaciones(
						filterReenvioComunicaciones != null ? filterReenvioComunicaciones
								: new ReenvioComunicaciones(), jqGridRequestDto);
		Long recordNum = this.reenvioComunicacionesDao
				.findReenvioComunicacionesCount(
						filterReenvioComunicaciones != null ? filterReenvioComunicaciones
								: new ReenvioComunicaciones(), jqGridRequestDto);

		return new JQGridResponseDto<ReenvioComunicaciones>(jqGridRequestDto,
				recordNum, listaComunicacionApertura);
	}

	/**
	 * Filter method in the ComunicacionesAperturas table.
	 * 
	 *  filterReenvioComunicaciones
	 *            ReenvioComunicaciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<ReenvioComunicaciones>
	 *
	 * @param filterReenvioComunicaciones the filter reenvio comunicaciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */

	public List<ReenvioComunicaciones> findListReenvioComunicaciones(
			ReenvioComunicaciones filterReenvioComunicaciones,
			JQGridRequestDto jqGridRequestDto) {

		return this.reenvioComunicacionesDao.findReenvioComunicaciones(
				filterReenvioComunicaciones, jqGridRequestDto);
	}
}
